
Partial Class ContentFiles_Download
    Inherits System.Web.UI.Page

    ''' <summary>
    ''' to zdarzenie load uruchamiane jest w celu wywietlenia
    ''' dialogu pobierania pliku
    ''' </summary>
    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        DisplayDownloadDialog(Config.ShareLocalFolderPath & _
            Resource.GetResourceFileName(Request.QueryString("resourceID")))

    End Sub


    ''' <summary>
    ''' Ta procedura obsugi zdarzenia preinicjalizacyjnego jest uruchamiana w celu przeprowadzenia inicjalizacji. 
    ''' Pozwala ona okreli motyw i tytu strony, ktre s wydobywane z pliku 
    ''' web.config za porednictwem udostpnionych waciwoci wspuytkowanej klasy Config.
    ''' </summary>
    Protected Sub Page_PreInit(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.PreInit
        Page.Theme = Config.CurrentTheme
        Page.Title = Config.PageTitle
    End Sub



    Sub DisplayDownloadDialog(ByVal PathVirtual As String)
        Dim strPhysicalPath As String
        Dim objFileInfo As System.IO.FileInfo
        Try

            Dim resourceID As Integer = Request.QueryString("resourceID")
            Dim senderEmail As String = EmailContent.GetEmailSenderForResource( _
                resourceID)
            Dim emailBody As String = "Twj plik zosta pobrany " & _
                System.DateTime.Today.ToLongDateString
            Utilities.SendEmail(senderEmail, Config.EmailFrom, _
                "Twj plik zosta pobrany", emailBody)

            strPhysicalPath = PathVirtual
            'wyjd, jeli plik nie istnieje
            If Not System.IO.File.Exists(strPhysicalPath) Then
                Exit Sub
            End If
            objFileInfo = New System.IO.FileInfo(strPhysicalPath)
            Response.Clear()
            'Dodaj nagwki, aby umoliwi wywietlenie dialogu
            Response.AddHeader("Content-Disposition", _
                "attachment; filename=" & objFileInfo.Name)
            Response.AddHeader("Content-Length", objFileInfo.Length.ToString())
            Response.ContentType = "application/octet-stream"
            Response.WriteFile(objFileInfo.FullName)
        Catch ex As Exception
            'Wywoujc wyraenie "Throw" przekazujemy bd do pliku global.asax, 
            'ktry wykorzysta domyln stron obsugi bdw do przetworzenia bdu
            'i wywietlenia uytkownikowi zdefiniowanego przez nas komunikatu o bdzie.
            Throw
        Finally
            Response.End()
        End Try
    End Sub




End Class
